/*  Änderung der Kapazitäten eines Wochentages behandeln. Offtimes anpassen. #19705, #20856
    Ursprünglich aus 0200 Tables\J abk.sql nach wkst_kap_belast__b_u
*/
DROP TRIGGER IF EXISTS wkst_kap_belast__a_iud__kapa ON wkst_kapbelast;
CREATE OR REPLACE FUNCTION wkst_kapbelast__a_iud__kapa() RETURNS TRIGGER AS $$
  DECLARE
      _weekstart      date;     -- Datum des Wochenstarts
      _toworkdates    date[];   -- Tage, welche von einem arbeitsfreiem Tag zu einem Arbeitstag für die Ressource wechseln
      _fromworkdates  date[];   -- Tage, welche von einem einem Arbeitstag zu arbeitsfreiem Tag für die Ressource wechseln
      _resource_id    int;      -- die betroffene Arbeitsplatzressource
      _ks             ksv;      -- die zugeörige Kostenstelle zum betroffenen Arbeitsplatz
      _ta_fk          numeric;  -- Maschinenanzahl des betroffenen Arbeitsplatzes

      _prefix varchar   := format( 'wkst_kapbelast__a_iud__kapa KS %L WEEK %L -', coalesce( new.wb_ks, old.wb_ks ), coalesce( new.wb_week, old.wb_week ) );
      _loglevel integer;
  BEGIN
      -- Startdatum der Woche, betroffene Arbeitsplatzressource und zugehörige Kostenstelle bestimmen.
      IF TG_OP = 'DELETE' THEN
          IF (old.wb_week < termweek(current_date - 90)) THEN
            RETURN old;
          END IF;
          _weekstart    := termweek_to_date( old.wb_week, true );
          _resource_id  := scheduling.resource__translate__ksvba__shorthand__to__resource_id( old.wb_ks );
      ELSE
          _weekstart    := termweek_to_date( new.wb_week, true );
          _resource_id  := scheduling.resource__translate__ksvba__shorthand__to__resource_id( new.wb_ks );
      END IF;

      -- Die zugeörige Kostenstelle zum betroffenen Arbeitsplatz bestimmen.
      _ks := ksv FROM ksv WHERE ks_abt = coalesce( new.wb_oks, old.wb_oks );

      -- Maschinenanzahl des betroffenen Arbeitsplatzes
      _ta_fk := r.ta_fk FROM scheduling.resource AS r  WHERE r.id = _resource_id AND r.context = 'ksvba';

      _loglevel := TSystem.Log_Get_LogLevel( _user => 'yes' );

      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '% ta_fk:%; mon:%:%:%; tue:%:%:%, wed:%:%:%; thu:%:%:%; fri:%:%:%; sat:%:%:%; sun:%:%:%;', _prefix, _ta_fk, _ks.ks_ka2 * _ta_fk, old.wb_kapa_mo, new.wb_kapa_mo, _ks.ks_ka3 * _ta_fk, old.wb_kapa_di, new.wb_kapa_di, _ks.ks_ka4 * _ta_fk, old.wb_kapa_mi, new.wb_kapa_mi, _ks.ks_ka5 * _ta_fk, old.wb_kapa_do, new.wb_kapa_do, _ks.ks_ka6 * _ta_fk, old.wb_kapa_fr, new.wb_kapa_fr, _ks.ks_ka7 * _ta_fk, old.wb_kapa_sa, new.wb_kapa_sa, _ks.ks_ka1 * _ta_fk, old.wb_kapa_so, new.wb_kapa_so;
      END IF;

      -- Tage zusammensammeln, an dem Wechsel zwischen arbeitsfreiem und Arbeitstag passieren.
      -- Fall 1: Arbeitsfreier Tag -> Arbeitstag
      IF coalesce( old.wb_kapa_mo, _ks.ks_ka2 * _ta_fk ) = 0 AND coalesce( new.wb_kapa_mo, _ks.ks_ka2 * _ta_fk ) > 0 THEN _toworkdates := array_append( _toworkdates, (_weekstart + interval '0 days')::date ); END IF; -- Montag
      IF coalesce( old.wb_kapa_di, _ks.ks_ka3 * _ta_fk ) = 0 AND coalesce( new.wb_kapa_di, _ks.ks_ka3 * _ta_fk ) > 0 THEN _toworkdates := array_append( _toworkdates, (_weekstart + interval '1 days')::date ); END IF; -- Dienstag
      IF coalesce( old.wb_kapa_mi, _ks.ks_ka4 * _ta_fk ) = 0 AND coalesce( new.wb_kapa_mi, _ks.ks_ka4 * _ta_fk ) > 0 THEN _toworkdates := array_append( _toworkdates, (_weekstart + interval '2 days')::date ); END IF;
      IF coalesce( old.wb_kapa_do, _ks.ks_ka5 * _ta_fk ) = 0 AND coalesce( new.wb_kapa_do, _ks.ks_ka5 * _ta_fk ) > 0 THEN _toworkdates := array_append( _toworkdates, (_weekstart + interval '3 days')::date ); END IF;
      IF coalesce( old.wb_kapa_fr, _ks.ks_ka6 * _ta_fk ) = 0 AND coalesce( new.wb_kapa_fr, _ks.ks_ka6 * _ta_fk ) > 0 THEN _toworkdates := array_append( _toworkdates, (_weekstart + interval '4 days')::date ); END IF;
      IF coalesce( old.wb_kapa_sa, _ks.ks_ka7 * _ta_fk ) = 0 AND coalesce( new.wb_kapa_sa, _ks.ks_ka7 * _ta_fk ) > 0 THEN _toworkdates := array_append( _toworkdates, (_weekstart + interval '5 days')::date ); END IF;
      IF coalesce( old.wb_kapa_so, _ks.ks_ka1 * _ta_fk ) = 0 AND coalesce( new.wb_kapa_so, _ks.ks_ka1 * _ta_fk ) > 0 THEN _toworkdates := array_append( _toworkdates, (_weekstart + interval '6 days')::date ); END IF; -- Sonntag
      -- Fall 2: Arbeitstag -> Arbeitsfreier Tag
      IF coalesce( old.wb_kapa_mo, _ks.ks_ka2 * _ta_fk ) > 0 AND coalesce( new.wb_kapa_mo, _ks.ks_ka2 * _ta_fk ) = 0 THEN _fromworkdates := array_append( _fromworkdates, (_weekstart + interval '0 days')::date ); END IF; -- Montag
      IF coalesce( old.wb_kapa_di, _ks.ks_ka3 * _ta_fk ) > 0 AND coalesce( new.wb_kapa_di, _ks.ks_ka3 * _ta_fk ) = 0 THEN _fromworkdates := array_append( _fromworkdates, (_weekstart + interval '1 days')::date ); END IF; -- Dienstag
      IF coalesce( old.wb_kapa_mi, _ks.ks_ka4 * _ta_fk ) > 0 AND coalesce( new.wb_kapa_mi, _ks.ks_ka4 * _ta_fk ) = 0 THEN _fromworkdates := array_append( _fromworkdates, (_weekstart + interval '2 days')::date ); END IF;
      IF coalesce( old.wb_kapa_do, _ks.ks_ka5 * _ta_fk ) > 0 AND coalesce( new.wb_kapa_do, _ks.ks_ka5 * _ta_fk ) = 0 THEN _fromworkdates := array_append( _fromworkdates, (_weekstart + interval '3 days')::date ); END IF;
      IF coalesce( old.wb_kapa_fr, _ks.ks_ka6 * _ta_fk ) > 0 AND coalesce( new.wb_kapa_fr, _ks.ks_ka6 * _ta_fk ) = 0 THEN _fromworkdates := array_append( _fromworkdates, (_weekstart + interval '4 days')::date ); END IF;
      IF coalesce( old.wb_kapa_sa, _ks.ks_ka7 * _ta_fk ) > 0 AND coalesce( new.wb_kapa_sa, _ks.ks_ka7 * _ta_fk ) = 0 THEN _fromworkdates := array_append( _fromworkdates, (_weekstart + interval '5 days')::date ); END IF;
      IF coalesce( old.wb_kapa_so, _ks.ks_ka1 * _ta_fk ) > 0 AND coalesce( new.wb_kapa_so, _ks.ks_ka1 * _ta_fk ) = 0 THEN _fromworkdates := array_append( _fromworkdates, (_weekstart + interval '6 days')::date ); END IF; -- Sonntag

      IF _loglevel >= 5 THEN
          RAISE NOTICE '% toworkdays: %, fromworkdays: %', _prefix, _toworkdates, _fromworkdates;
      END IF;

      -- Offtimes der ermittelten Tage umschreiben.
      PERFORM scheduling.resource_timeline__rewrite_offtime(
                  _resource_id  => _resource_id,
                  _date         => _date,
                  _toworkday    => true,
                  _loglevel     => _loglevel
              )
         FROM unnest( _toworkdates ) AS t( _date );
      PERFORM scheduling.resource_timeline__rewrite_offtime(
                  _resource_id  => _resource_id,
                  _date         => _date,
                  _toworkday    => false,
                  _loglevel     => _loglevel
              )
         FROM unnest( _fromworkdates ) AS t( _date );

      RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER wkst_kap_belast__a_iud__kapa
    AFTER INSERT OR UPDATE OF wb_kapa_mo, wb_kapa_di, wb_kapa_mi, wb_kapa_do, wb_kapa_fr, wb_kapa_sa, wb_kapa_so
    OR DELETE
    ON wkst_kapbelast
    FOR EACH ROW    
    EXECUTE PROCEDURE wkst_kapbelast__a_iud__kapa();
--